﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FslWinusb;

/*Test made by Paolo Alcantara*/

namespace WinUSBExample
{
    public partial class Form1 : Form
    {
        //defines
        public const uint PIPE_TRANSFER_TIMEOUT = 3;
        
        /*global variables*/
        Boolean Connected = false;

        //device number 1 handler init
        FslWinusb.FslWinusb myDevice = new FslWinusb.FslWinusb();
        //USB ID for Windows
        Guid myGuid = new Guid("77519ae1-c5be-4324-95ae-0141089e90ac");
        //ep0 Interrupt IN
        FslWinusb.FslWinusb.WINUSB_PIPE_INFORMATION usb_ep0; 
        //ep1 BULK OUT
        FslWinusb.FslWinusb.WINUSB_PIPE_INFORMATION usb_ep1;

        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
          if( Connected == false )
          {  
            //myDevice init
            bool isConnected = myDevice.usb_open_device(myGuid);
            /*inform app that it has been opened*/
            if (isConnected == true)
            {
                //opened
                EndPointInit();
                Connected = true;
            }
            else
            {
                //error
                Connected = false;
            }
          }
        }

    /*Function called to start endpoints (2) of app*/
    public Boolean EndPointInit()
    {
        Boolean result = false;
        uint time = 5;

        //endpoint handlers
        result = myDevice.usb_QueryPipe(0, 0, ref usb_ep0);
        result = myDevice.usb_QueryPipe(0, 1, ref usb_ep1);
       
        //endpoint timeouts
        result = myDevice.usb_SetPipePolicy(usb_ep0.PipeId, PIPE_TRANSFER_TIMEOUT, 4, out time);
        result = myDevice.usb_SetPipePolicy(usb_ep1.PipeId, PIPE_TRANSFER_TIMEOUT, 4, out time);

        //setting endpoint timer and enabling it for interrupt ep
        timer1.Interval = 2 ^ (usb_ep0.Interval - 1);
        timer1.Enabled = true;

        return result;
    }

        private void button2_Click(object sender, EventArgs e)
        {
            timer1.Enabled = false;
            
            /* close connection only if was already opened */
            if( Connected == true )
            {
                myDevice.usb_Free();
                Connected = false;
                /*For now close the GUI*/
                Dispose(true);
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            uint how_data_transferred = 0;
            byte[] MyBuffer = new byte[8];

            timer1.Enabled = false;
            if (myDevice.usb_ReadPipe(usb_ep0.PipeId, ref MyBuffer, 8, ref how_data_transferred))
            {
                //received data
                textBox1.Text = MyBuffer[0].ToString();
            }
            else 
            {
                //error 
                textBox1.Text = "error";
            }
            timer1.Enabled = true;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            //TODO: add control support
        }
    }
}
